<?php
/**
 * Clase para Configurar el cliente
 * @Filename: Config.class.php
 * @version: 2.0
 * @Author: flow.cl
 * @Email: csepulveda@tuxpan.com
 * @Date: 28-04-2017 11:32
 * @Last Modified by: Carlos Sepulveda
 * @Last Modified time: 28-04-2017 11:32
 */

 require_once "/var/www/html/track/config.php";
 
 $COMMERCE_CONFIG = array(
 	"APIKEY" => $gsValues["BILLING_API_KEY"], // Registre aquí su apiKey
 	"SECRETKEY" => $gsValues["BILLING_SECRET_KEY"], // Registre aquí su secretKey
 	"APIURL" => $gsValues["BILLING_API_URL"], // Producción EndPoint o Sandbox EndPoint
 	"BASEURL" => $gsValues["URL_ROOT"] //Registre aquí la URL base en su página donde instalará el cliente
 );
 
 class Config {
 	
	static function get($name) {
		global $COMMERCE_CONFIG;
		if(!isset($COMMERCE_CONFIG[$name])) {
			throw new Exception("The configuration element thas not exist", 1);
		}
		return $COMMERCE_CONFIG[$name];
	}
 }
