<?php
error_reporting(0);
// Incluir dependencias
include('/var/www/html/track/server/s_insert.php');
include('/var/www/html/track/server/eventos.php');

// Obtener los datos crudos
$data_raw = file_get_contents("php://input");

// Registrar los datos crudos para análisis
// error_log("Datos crudos recibidos: " . $data_raw);

// Verificar si los datos están vacíos
if (empty($data_raw)) {
    error_log("No se recibieron datos.", 0);
    exit("No se recibieron datos.");
}

// Limpiar caracteres escapados
$data_clean = stripslashes($data_raw);

// Eliminar corchetes al inicio y al final
$data_clean = trim($data_clean, '[]');

// Decodificar el JSON principal
$data = json_decode($data_clean, true);

// Validar errores de JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    $json_error = json_last_error_msg();
    // error_log("Error al decodificar JSON principal: $json_error", 0);
    // error_log("Datos procesados que causaron el error: " . $data_clean, 0);
    exit("Error al decodificar JSON principal: $json_error");
}

// Eliminar el campo 'params' si existe
//if (isset($data['params'])) {
//    unset($data['params']);
//}

// Registrar datos decodificados para depuración
// error_log("Datos decodificados exitosamente " . json_encode($data, JSON_PRETTY_PRINT));

if (!isset($data['imei'])) {
    mysqli_close($ms);
    die;
}

if ($data['lat'] == 0 && $data['lng'] == 0) {
 // Usar el IMEI del array $data y la conexión correcta $ms
    $imei = $data['imei'];
    $sql = "SELECT lat, lng, speed, angle, altitude, loc_valid, odometer, satelites 
            FROM gs_objects 
            WHERE imei = '$imei'";
    
    $result = $ms->query($sql);
    
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        // Actualizar los valores en $data
        $data['lat'] = $row["lat"];
        $data['lng'] = $row["lng"];
        $data['speed'] = $row["speed"];
        $data['angle'] = $row["angle"];
        $data['altitude'] = $row["altitude"];
        $data['loc_valid'] = $row["loc_valid"];
        $data['odometer'] = $row["odometer"];
        $data['satelites'] = $row["satelites"];
    } else {
        error_log("No se encontraron coordenadas anteriores para IMEI: $imei");
        mysqli_close($ms);
        die;
    }
}

$data['dt_server'] = gmdate("Y-m-d H:i:s");
    if (!isset($data['dt_tracker'])) {
        mysqli_close($ms);
        die;
    }

// Continuar con el procesamiento
if (isset($data['imei'])) {
    // error_log("Datos decodificados exitosamente : " . json_encode($data, JSON_PRETTY_PRINT));
    //error_log("IMEI: " . $data['imei'], 0);

    if ($data["op"] == "loc") {
        insert_db_loc($data);
    } elseif ($data["op"] == "noloc") {
        insert_db_noloc($data);
    } elseif ($data["op"] == "imgloc") {
        insert_db_imgloc($data);
    }


} else {
    error_log("El índice 'imei' no existe en los datos recibidos.", 0);
    exit("El índice 'imei' no existe.");
}
?>
