// Comprobar si el auto permite corte de motor y/o abrir puerta
function tieneCorteMotor(corteMotor) {
    try {
        if (corteMotor == 1 || corteMotor == 3) {
          return true;
        } else {
          return false;
        }
    } catch (e) {
        console.error(e);
        return false;
    }
}
  
  //Validar rele para mostrar el boton correspondiente
function validarEstadoRele(releActivo) {
    try {
        if ([0, 1].includes(+releActivo)) return +releActivo;
    } catch (e) {
        console.error(e);
        return 2;
    }
    return 2;
}
  
  //enviar comando corte
  /* 
  @param index: int
  @param accion: (motor | abrir_puertas | cerrar_puertas)
   */function enviarComandoCorte({ imei, corte_motor, rele_activo, comando_corte, plate_number }, dt_tracker, comando, baseUrl = "http://198.58.110.186:19881/motor_cut") {
    const infoComando = { imei, comando };
    let newText2 = '';
    let newText3 = '';

    const ahora = new Date();
    const tiempoTranscurrido = ahora - new Date(dt_tracker);
    const diasTranscurridos = Math.floor(tiempoTranscurrido / (1000 * 60 * 60 * 24));

    // Revisar si han pasado más de 3 días
    if (tiempoTranscurrido > 3 * 24 * 60 * 60 * 1000) {
        newText3 += `Hace ${diasTranscurridos} días que el vehículo no envía información. <br>Por favor, dar contacto al vehículo para que vuelva a reportar.<br>`;
    }

    // Revisar si ya se envió el comando
    if (comando_corte === 'setdigout 1') {
        newText2 += '<br>Ya se envió el comando de corte a este vehículo.';
    }
    if (comando_corte === 'setdigout 0') {
        newText2 += '<br>Ya se envió el comando de restablecimiento a este vehículo.';
    }

    const newText = [
        newText3 + newText2,
        `Última señal: ${dt_tracker}`,
        `<br>Ingrese su contraseña`
    ].filter(Boolean).join('<br>');

    textInputDialog({
            title: "Confirmar Corte: " + plate_number,
            text: newText,
            placeholder: "Contraseña",
            type: "password"
        },
        async (value, text, close) => {
            $("#dialog_text_input").val("");

            if (!value) return;

            if (!tieneCorteMotor(corte_motor)) {
                console.error("No tiene corte motor");
                return;
            }
            if (![0, 1].includes(validarEstadoRele(rele_activo))) {
                console.error("Valor del rele inválido");
                return;
            }

            infoComando.password = text;

            const res = await fetch(encodeURI(baseUrl), {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(infoComando)
            });

            if (!res) throw new Error("Sin respuesta...");

            if (res.status === 200) {
                // const releState = rele_activo == 1 ? '#9CC602' : '#FF5E5E';
                // $("#object_rele_" + imei).find("path").attr("fill", releState); // actualiza (front) en respuesta exitosa..

                refrescarIndicadorRele(rele_activo); // flujo previo.. 
                notifyDialog(`La solicitud de ${rele_activo == 1 ? 'restablecimiento ' : 'corte'} se envió correctamente al vehículo.`);
            } else if (res.status === 403) {
                notifyDialog(await res.text());
            }
        }
    );
}



const colorMap = new Map([
    ["0", "#9CC602"],
    ["1", "#ff5e5e"]
]);
// Cambia color de círculo que indica si el motor se encuentra encendido o apagado
function refrescarIndicadorRele(rele_activo, imei) {
    
    if (!imei) {
        $("#indicador_rele_activo").css("background-color", colorMap.get(rele_activo));
        return;
    }

    $("#object_rele_" + imei).find("path").attr("fill", colorMap.get(rele_activo));
}




// backup

// Comprobar si el auto permite corte de motor y/o abrir puerta

// function tieneCorteMotor(corteMotor) {
//     try {
//         if (corteMotor == 1 || corteMotor == 3) {
//           return true;
//         } else {
//           return false;
//         }
//     } catch (e) {
//         console.error(e);
//         return false;
//     }
// }
  
//Validar rele para mostrar el boton correspondiente

// function validarEstadoRele(releActivo) {
//     try {
//         if ([0, 1].includes(+releActivo)) return +releActivo;
//     } catch (e) {
//         console.error(e);
//         return 2;
//     }
//     return 2;
// }
  
//enviar comando corte
   /* 
   @param index: int
   @param accion: (motor | abrir_puertas | cerrar_puertas)
    */

// function enviarComandoCorte({ imei, corte_motor, rele_activo }, comando, baseUrl = "http://198.58.110.186:19881/motor_cut") {

//     const infoComando = {
//         imei,
//         comando
//     };

//     textInputDialog({
//             title: "Confirmar Acción",
//             text: "Ingrese su contraseña de usuario.",
//             placeholder: "Contraseña",
//             type: "password"
//         },
//         async (value, text, close) => {
            
//             $("#dialog_text_input").val("");
            
//             if (!value) {
//                 return;
//             }

//             if (!tieneCorteMotor(corte_motor)) {
//                 console.error("No tiene corte motor");
//                 return;
//             }
//             if (![0, 1].includes(validarEstadoRele(rele_activo))) {
//                 console.error("Valor del rele inválido");
//                 return;
//             }

//             const header = {
//                 "Content-Type": "application/json"
//             };

//             infoComando.password = text;

//             const url = encodeURI(baseUrl);
//             const res = await fetch(
//                 url,
//                 {
//                     method: "POST",
//                     headers: header,
//                     body: JSON.stringify(infoComando),
//                 }
//             );

//             if (res == null ){
//                 throw new Exception("Sin respuesta...");
//             }

//             if (res.status) {
//                 code = res.status;
                
//                 if (res.status == 200) {
//                     refrescarIndicadorRele(rele_activo);
//                     return;
//                 }
//                 if (res.status == 403) {
//                     notifyDialog(await res.text());
//                     return;
//                 }
//             }
//         }
//     );
// }

// const colorMap = new Map([
//     ["0", "#9CC602"],
//     ["1", "#ff5e5e"]
// ]);

// Cambia color de círculo que indica si el motor se encuentra encendido o apagado

// function refrescarIndicadorRele(rele_activo, imei) {
    
//     if (!imei) {
//         $("#indicador_rele_activo").css("background-color", colorMap.get(rele_activo));
//         return;
//     }

//     $("#object_rele_" + imei).find("path").attr("fill", colorMap.get(rele_activo));
// }