<?php
error_log($_SERVER['SCRIPT_NAME']);
function createDocument($accessToken, $amount, $product) {
    global $gsValues;
    
    $amountMinusIVA = $amount/1.19;
    
    $estructura_json = [
        'codeSii'      => '39',
        'declareSii'   => $gsValues["BSALE_DECLARE_SII"],
        'officeId'     => '1',
        'emissionDate' => time(),
        'details'      => [
            [
                'netUnitValue' => $amountMinusIVA,
                'quantity'     => 1,
                'comment'      => $product,
                'taxes'        => [
                    [
                        'code'       => 14,
                        'percentage' => 19,
                    ],
                ],
            ],
        ],
    ];

    $url='https://api.bsale.cl/v1/documents.json';

    $data =  json_encode($estructura_json);
    $ch = curl_init($url);
    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    
    $headers = array(
        'access_token: ' . $accessToken,
        'Accept: application/json',
        'Content-Type: application/json'
    );

    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    
    $response = curl_exec($ch);
    
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);
    
    return json_decode($response);
}
