<?php
// Clave de encriptación
$key = 'Stech';

// Función para desencriptar
function decrypt($data, $key) {
    list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
    return openssl_decrypt($encrypted_data, 'aes-256-cbc', $key, 0, $iv);
}

// Obtener y desencriptar la variable encriptada
$encryptedData = $_GET['data'];
$decryptedData = decrypt($encryptedData, $key);

// Separar los datos
list($imei, $fechaHora) = explode('||', $decryptedData);

// Verificar si la fecha y hora es válida
if (!$fechaHora) {
    die('El parámetro fecha_hora es requerido.');
}

// Verificar si la ejecución está dentro del límite de 24 horas
$fechaEntrada = strtotime($fechaHora);
$fechaLimite = strtotime('+24 hours', $fechaEntrada);
if (time() > $fechaLimite) {
    die('La ejecución ha excedido el límite de 24 horas.');
}

// Conexión a la base de datos
$servername = '10.118.144.75';
$username = 'web';
$password = 'mYREbJG0E1lW';
$dbname = 'gpsimple';

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die('Error al conectar a la base de datos: ' . $conn->connect_error);
}

// Obtener la posición del punto desde la base de datos
$sql = "SELECT lat, lng, speed, plate_number FROM gs_objects WHERE imei = '$imei'";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $latitud = $row['lat'];
    $longitud = $row['lng'];
    $nombre = $row['plate_number'];
    $velocidad = $row['speed'];

    // Mostrar el punto en el mapa utilizando Leaflet
    echo '<style>
            html, body, #map {
                height: 100%;
                margin: 0;
                padding: 0;
            }
            .watermark {
                position: absolute;
                bottom: 10px;
                right: 10px;
                opacity: 0.5;
                z-index: 1000;
            }
            .leaflet-popup-content-wrapper {
                background-color: rgba(255, 255, 255, 0.5); /* Fondo semitransparente */
            }
            .leaflet-popup-tip {
                background-color: rgba(255, 255, 255, 0.5); /* Fondo semitransparente */
            }
          </style>';
    echo '<div id="map"></div>';
    echo '<img src="img/logo.png" class="watermark" alt="Marca de agua">';
    echo '<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />';
    echo '<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>';
    echo '<script>';
    echo 'var map = L.map("map").setView([' . $latitud . ', ' . $longitud . '], 15);';
    echo 'L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
            maxZoom: 19
          }).addTo(map);';

    echo 'var marker = L.marker([' . $latitud . ', ' . $longitud . ']).addTo(map);';
    echo 'marker.bindPopup("<table><tr><td><b>Patente</b></td><td>' . $nombre . '</td></tr><tr><td><b>Velocidad</b></td><td>' . $velocidad . ' Km/H</td></tr></table>").openPopup();';

    echo 'window.addEventListener("resize", function() {';
    echo '    map.invalidateSize();';
    echo '});';

    echo 'var markerExists = true;';
    echo 'var mapInitialized = true;';
    echo '</script>';

    // Actualizar automáticamente la posición del punto cada 30 segundos
    echo '<script>';
    echo 'setInterval(function() {';
    echo '    if (mapInitialized) {';
    echo '        fetch("coordenadas.php?data=' . $encryptedData . '").then(response => response.json()).then(data => {';
    echo '            if (data.lat && data.lng) {';
    echo '                var newLatLng = L.latLng(data.lat, data.lng);';
    echo '                if (markerExists) {';
    echo '                    marker.setLatLng(newLatLng);';
    echo '                } else {';
    echo '                    marker = L.marker(newLatLng).addTo(map);';
    echo '                    markerExists = true;';
    echo '                }';
    echo '                map.setView(newLatLng, map.getZoom());';
    echo '                marker.setPopupContent("<table><tr><td><b>Patente</b></td><td>" + data.plate_number + "</td></tr><tr><td><b>Velocidad</b></td><td>" + data.speed + " Km/H</td></tr></table>").openPopup();';
    echo '            }';
    echo '        }).catch(error => {';
    echo '            console.error("Error fetching data: ", error);';
    echo '        });';
    echo '    }';
    echo '}, 30000);';
    echo '</script>';
} else {
    echo 'No se encontró la posición del punto para el IMEI especificado.';
}

$conn->close();
?>
